/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.custom_blocks;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import com.moulberry.axiom.custom_blocks.CustomBlock;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.CustomBlockStateImplementation;
import com.moulberry.axiom.custom_blocks.update.CustomBlockPlacementLogic;
import com.moulberry.axiom.utils.IntWrapper;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class CustomBlockImplementation
implements CustomBlock {
    private final class_2960 resourceLocation;
    private final String translationKey;
    private final class_1799 pickBlockItemStack;
    private final boolean sendServerPickBlockIfPossible;
    private final boolean preventRightClickInteraction;
    private final boolean preventShapeUpdates;
    private final CustomBlockState defaultBlockState;
    private final class_2689<CustomBlock, CustomBlockStateImplementation> stateDefinition;
    private final List<CustomBlockPlacementLogic> placementLogics;

    public CustomBlockImplementation(class_2960 resourceLocation, String translationKey, List<class_2769<?>> properties, List<class_2680> vanillaStates, @Nullable class_1799 pickBlockItemStack, boolean sendServerPickBlockIfPossible, boolean preventRightClickInteraction, boolean preventShapeUpdates, List<CustomBlockPlacementLogic> placementLogics) {
        IntWrapper index = new IntWrapper();
        class_2689.class_2690 builder = new class_2689.class_2690((Object)this);
        properties.forEach(xva$0 -> builder.method_11667(new class_2769[]{xva$0}));
        class_2689 stateDefinition = builder.method_11668(customBlock -> (CustomBlockStateImplementation)customBlock.axiom$defaultCustomState(), (block, immutableMap, mapCodec) -> {
            if (index.value >= vanillaStates.size()) {
                throw new RuntimeException(String.valueOf(resourceLocation) + " - faulty definition: not enough vanilla states");
            }
            class_2680 vanillaState = (class_2680)vanillaStates.get(index.value);
            ++index.value;
            return new CustomBlockStateImplementation((CustomBlock)block, vanillaState, (ImmutableMap<class_2769<?>, Comparable<?>>)immutableMap, (MapCodec<CustomBlockStateImplementation>)mapCodec);
        });
        if (index.value < vanillaStates.size()) {
            throw new RuntimeException(String.valueOf(resourceLocation) + " - faulty definition: too many vanilla states");
        }
        this.resourceLocation = resourceLocation;
        this.translationKey = translationKey;
        this.pickBlockItemStack = pickBlockItemStack;
        this.sendServerPickBlockIfPossible = sendServerPickBlockIfPossible;
        this.preventRightClickInteraction = preventRightClickInteraction;
        this.preventShapeUpdates = preventShapeUpdates;
        this.stateDefinition = stateDefinition;
        this.defaultBlockState = (CustomBlockState)stateDefinition.method_11664();
        this.placementLogics = placementLogics;
        for (CustomBlockPlacementLogic placementLogic : this.placementLogics) {
            if (placementLogic.hasRequiredProperties(this.stateDefinition.method_11659())) continue;
            throw new RuntimeException(String.valueOf(resourceLocation) + " - state definition doesn't contain required property for " + String.valueOf(placementLogic.getClass()));
        }
    }

    @Override
    public class_2960 axiom$getIdentifier() {
        return this.resourceLocation;
    }

    @Override
    public String axiom$translationKey() {
        return this.translationKey;
    }

    @Override
    public class_1799 axiom$customPickBlockStack() {
        return this.pickBlockItemStack == null ? null : this.pickBlockItemStack.method_7972();
    }

    @Override
    public class_1799 axiom$asItemStack() {
        class_1799 customPickBlockStack = this.axiom$customPickBlockStack();
        if (customPickBlockStack != null && !customPickBlockStack.method_7960()) {
            return customPickBlockStack;
        }
        return new class_1799((class_1935)this.defaultBlockState.getVanillaState().method_26204().method_8389());
    }

    @Override
    public boolean sendServerPickBlockIfPossible() {
        return this.sendServerPickBlockIfPossible;
    }

    @Override
    public boolean preventRightClickInteraction() {
        return this.preventRightClickInteraction;
    }

    @Override
    public boolean preventShapeUpdates() {
        return this.preventShapeUpdates;
    }

    public class_2689<CustomBlock, CustomBlockStateImplementation> getStateDefinition() {
        return this.stateDefinition;
    }

    @Override
    public Collection<class_2769<?>> axiom$getProperties() {
        return this.stateDefinition.method_11659();
    }

    @Override
    public List<CustomBlockState> axiom$getPossibleCustomStates() {
        return this.stateDefinition.method_11662();
    }

    @Override
    public CustomBlockState axiom$defaultCustomState() {
        return this.defaultBlockState;
    }

    @Override
    @Nullable
    public CustomBlockState getCustomStateForPlacement(class_1750 blockPlaceContext, boolean force) {
        CustomBlockState blockState = this.defaultBlockState;
        for (CustomBlockPlacementLogic updater : this.placementLogics) {
            CustomBlockState newBlockState = updater.getStateForPlacement(blockState, blockPlaceContext);
            if (newBlockState == null) {
                if (!force) break;
                continue;
            }
            blockState = newBlockState;
        }
        return blockState;
    }
}

