/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.configuration.legacy;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.configuration.AxiomConfig;
import com.moulberry.axiom.configuration.legacy.BlockAttributesConfigurationLegacy;
import com.moulberry.axiom.configuration.legacy.BlueprintConfigurationLegacy;
import com.moulberry.axiom.configuration.legacy.CapabilitiesConfigurationLegacy;
import com.moulberry.axiom.configuration.legacy.InternalConfigurationLegacy;
import com.moulberry.axiom.configuration.legacy.KeybindConfigurationLegacy;
import com.moulberry.axiom.configuration.legacy.RenderingConfigurationLegacy;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;

public class LegacyConfiguration {
    public static void tryLoadAndApplyLegacy(Path mainPath, Path internalPath, AxiomConfig newConfiguration) {
        boolean appliedMainConfig = false;
        try {
            if (Files.exists(mainPath, new LinkOption[0]) && Files.size(mainPath) > 1L) {
                HoconConfigurationLoader mainLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(mainPath)).build();
                CommentedConfigurationNode mainRoot = (CommentedConfigurationNode)mainLoader.load();
                CapabilitiesConfigurationLegacy capabilities = new CapabilitiesConfigurationLegacy((CommentedConfigurationNode)mainRoot.node(new Object[]{"capabilities"}));
                BlockAttributesConfigurationLegacy blockAttributes = new BlockAttributesConfigurationLegacy((CommentedConfigurationNode)mainRoot.node(new Object[]{"blockAttributes"}));
                RenderingConfigurationLegacy rendering = new RenderingConfigurationLegacy((CommentedConfigurationNode)mainRoot.node(new Object[]{"rendering"}));
                KeybindConfigurationLegacy keybind = new KeybindConfigurationLegacy((CommentedConfigurationNode)mainRoot.node(new Object[]{"keybinds"}));
                BlueprintConfigurationLegacy blueprint = new BlueprintConfigurationLegacy((CommentedConfigurationNode)mainRoot.node(new Object[]{"blueprint"}));
                capabilities.applyToNewConfiguration(newConfiguration);
                blockAttributes.applyToNewConfiguration(newConfiguration);
                rendering.applyToNewConfiguration(newConfiguration);
                keybind.applyToNewConfiguration(newConfiguration);
                blueprint.applyToNewConfiguration(newConfiguration);
                appliedMainConfig = true;
            }
        }
        catch (Exception e) {
            Axiom.LOGGER.error("Failed to load and apply legacy main config", e);
        }
        boolean appliedInternalConfig = false;
        try {
            if (Files.exists(internalPath, new LinkOption[0]) && Files.size(internalPath) > 1L) {
                HoconConfigurationLoader internalLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(internalPath)).build();
                CommentedConfigurationNode internalRoot = (CommentedConfigurationNode)internalLoader.load();
                InternalConfigurationLegacy internal = new InternalConfigurationLegacy(internalRoot);
                internal.applyToNewConfiguration(newConfiguration);
                appliedInternalConfig = true;
            }
        }
        catch (Exception e) {
            Axiom.LOGGER.error("Failed to load and apply legacy internal config", e);
        }
        if (appliedMainConfig || appliedInternalConfig) {
            newConfiguration.saveToDefaultFolder();
        }
        if (appliedMainConfig) {
            try {
                Files.deleteIfExists(mainPath);
            }
            catch (IOException e) {
                Axiom.LOGGER.error("Failed to delete legacy main config", e);
            }
        }
        if (appliedInternalConfig) {
            try {
                Files.deleteIfExists(internalPath);
            }
            catch (IOException e) {
                Axiom.LOGGER.error("Failed to delete legacy internal config", e);
            }
        }
    }

    private static void init() {
    }
}

