/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.collections;

import com.moulberry.axiom.BuildConfig;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.utils.PositionUtils;
import com.moulberry.axiomclientapi.funcinterfaces.TriIntConsumer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import net.minecraft.class_2338;

public class PositionSet {
    private final Long2ObjectMap<short[]> map = new Long2ObjectOpenHashMap();
    private int count = 0;
    private long lastChunkPos = PositionUtils.MIN_POSITION_LONG;
    private short[] lastChunk = null;

    public int chunkCount() {
        return this.map.size();
    }

    public int count() {
        return this.count;
    }

    @Deprecated
    public void unsafeSetCount(int count) {
        this.count = count;
    }

    public void validateCount() {
        int actualCount = 0;
        ObjectIterator objectIterator = this.map.values().iterator();
        while (objectIterator.hasNext()) {
            short[] chunk;
            for (short value : chunk = (short[])objectIterator.next()) {
                actualCount += Integer.bitCount(value & 0xFFFF);
            }
        }
        if (actualCount != this.count) {
            throw new FaultyImplementationError("The count of this PositionSet is incorrect");
        }
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public void clear() {
        this.map.clear();
        this.count = 0;
        this.lastChunkPos = PositionUtils.MIN_POSITION_LONG;
        this.lastChunk = null;
    }

    public PositionSet copy() {
        PositionSet copy = new PositionSet();
        copy.count = this.count;
        for (Long2ObjectMap.Entry entry : this.map.long2ObjectEntrySet()) {
            short[] array = (short[])entry.getValue();
            copy.map.put(entry.getLongKey(), (Object)Arrays.copyOf(array, array.length));
        }
        return copy;
    }

    public boolean contains(int x, int y, int z) {
        if (this.count == 0) {
            return false;
        }
        int xC = x >> 4;
        int yC = y >> 4;
        int zC = z >> 4;
        short[] array = this.getChunk(xC, yC, zC);
        if (array == null) {
            return false;
        }
        int offset = (y & 0xF) + (z & 0xF) * 16;
        int bit = 1 << (x & 0xF);
        return (array[offset] & bit) != 0;
    }

    public boolean containsInXRow(int x, int y, int z) {
        if (this.count == 0) {
            return false;
        }
        int xC = x >> 4;
        int yC = y >> 4;
        int zC = z >> 4;
        short[] array = this.getChunk(xC, yC, zC);
        if (array == null) {
            return false;
        }
        int offset = (y & 0xF) + (z & 0xF) * 16;
        return array[offset] != 0;
    }

    public boolean add(int x, int y, int z) {
        int bit;
        int offset;
        int xC = x >> 4;
        int yC = y >> 4;
        int zC = z >> 4;
        short[] array = this.getOrCreateChunk(xC, yC, zC);
        if ((array[offset = (y & 0xF) + (z & 0xF) * 16] & (bit = 1 << (x & 0xF))) == 0) {
            int n = offset;
            array[n] = (short)(array[n] | bit);
            ++this.count;
            return true;
        }
        return false;
    }

    public boolean remove(int x, int y, int z) {
        int xC = x >> 4;
        int yC = y >> 4;
        int zC = z >> 4;
        short[] array = this.getChunk(xC, yC, zC);
        if (array == null) {
            return false;
        }
        int offset = (y & 0xF) + (z & 0xF) * 16;
        int bit = 1 << (x & 0xF);
        if ((array[offset] & bit) != 0) {
            int n = offset;
            array[n] = (short)(array[n] & ~bit);
            --this.count;
            return true;
        }
        return false;
    }

    public void forEach(TriIntConsumer consumer) {
        for (Long2ObjectMap.Entry entry : this.map.long2ObjectEntrySet()) {
            int cx = class_2338.method_10061((long)entry.getLongKey()) * 16;
            int cy = class_2338.method_10071((long)entry.getLongKey()) * 16;
            int cz = class_2338.method_10083((long)entry.getLongKey()) * 16;
            int index = 0;
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 16; ++y) {
                    short v = ((short[])entry.getValue())[index++];
                    if (v == -1) {
                        consumer.accept(cx + 0, cy + y, cz + z);
                        consumer.accept(cx + 1, cy + y, cz + z);
                        consumer.accept(cx + 2, cy + y, cz + z);
                        consumer.accept(cx + 3, cy + y, cz + z);
                        consumer.accept(cx + 4, cy + y, cz + z);
                        consumer.accept(cx + 5, cy + y, cz + z);
                        consumer.accept(cx + 6, cy + y, cz + z);
                        consumer.accept(cx + 7, cy + y, cz + z);
                        consumer.accept(cx + 8, cy + y, cz + z);
                        consumer.accept(cx + 9, cy + y, cz + z);
                        consumer.accept(cx + 10, cy + y, cz + z);
                        consumer.accept(cx + 11, cy + y, cz + z);
                        consumer.accept(cx + 12, cy + y, cz + z);
                        consumer.accept(cx + 13, cy + y, cz + z);
                        consumer.accept(cx + 14, cy + y, cz + z);
                        consumer.accept(cx + 15, cy + y, cz + z);
                        continue;
                    }
                    if (v == 0) continue;
                    if ((v & 1) != 0) {
                        consumer.accept(cx + 0, cy + y, cz + z);
                    }
                    if ((v & 2) != 0) {
                        consumer.accept(cx + 1, cy + y, cz + z);
                    }
                    if ((v & 4) != 0) {
                        consumer.accept(cx + 2, cy + y, cz + z);
                    }
                    if ((v & 8) != 0) {
                        consumer.accept(cx + 3, cy + y, cz + z);
                    }
                    if ((v & 0x10) != 0) {
                        consumer.accept(cx + 4, cy + y, cz + z);
                    }
                    if ((v & 0x20) != 0) {
                        consumer.accept(cx + 5, cy + y, cz + z);
                    }
                    if ((v & 0x40) != 0) {
                        consumer.accept(cx + 6, cy + y, cz + z);
                    }
                    if ((v & 0x80) != 0) {
                        consumer.accept(cx + 7, cy + y, cz + z);
                    }
                    if ((v & 0x100) != 0) {
                        consumer.accept(cx + 8, cy + y, cz + z);
                    }
                    if ((v & 0x200) != 0) {
                        consumer.accept(cx + 9, cy + y, cz + z);
                    }
                    if ((v & 0x400) != 0) {
                        consumer.accept(cx + 10, cy + y, cz + z);
                    }
                    if ((v & 0x800) != 0) {
                        consumer.accept(cx + 11, cy + y, cz + z);
                    }
                    if ((v & 0x1000) != 0) {
                        consumer.accept(cx + 12, cy + y, cz + z);
                    }
                    if ((v & 0x2000) != 0) {
                        consumer.accept(cx + 13, cy + y, cz + z);
                    }
                    if ((v & 0x4000) != 0) {
                        consumer.accept(cx + 14, cy + y, cz + z);
                    }
                    if ((v & 0x8000) == 0) continue;
                    consumer.accept(cx + 15, cy + y, cz + z);
                }
            }
        }
    }

    public void forEachChunk(ChunkConsumer consumer) {
        for (Long2ObjectMap.Entry entry : this.map.long2ObjectEntrySet()) {
            int cx = class_2338.method_10061((long)entry.getLongKey());
            int cy = class_2338.method_10071((long)entry.getLongKey());
            int cz = class_2338.method_10083((long)entry.getLongKey());
            consumer.accept(cx, cy, cz, (short[])entry.getValue());
        }
    }

    public LongSet calculateChunksChanged(PositionSet other) {
        LongOpenHashSet changed = new LongOpenHashSet();
        for (Long2ObjectMap.Entry entry : this.map.long2ObjectEntrySet()) {
            short[] thisArray;
            short[] otherArray = other.getChunk(entry.getLongKey());
            if (Arrays.equals(otherArray, thisArray = (short[])entry.getValue())) continue;
            changed.add(entry.getLongKey());
        }
        return changed;
    }

    public LongSet chunkKeySet() {
        return this.map.keySet();
    }

    @Deprecated
    public Long2ObjectMap<short[]> unsafeGetRawMap() {
        return this.map;
    }

    public void removeEmptyChunk(long pos) {
        if (this.lastChunkPos == pos) {
            this.lastChunkPos = PositionUtils.MIN_POSITION_LONG;
            this.lastChunk = null;
        }
        short[] array = (short[])this.map.remove(pos);
        if (BuildConfig.DEBUG) {
            for (short s2 : array) {
                if (s2 == 0) continue;
                throw new FaultyImplementationError("Chunk is not empty");
            }
        }
    }

    public int removeChunk(long pos) {
        short[] array;
        if (this.lastChunkPos == pos) {
            this.lastChunkPos = PositionUtils.MIN_POSITION_LONG;
            this.lastChunk = null;
        }
        if ((array = (short[])this.map.remove(pos)) == null) {
            return 0;
        }
        int removedCount = 0;
        for (short s2 : array) {
            removedCount += Integer.bitCount(s2 & 0xFFFF);
        }
        this.count -= removedCount;
        return removedCount;
    }

    public short[] getChunk(int xC, int yC, int zC) {
        return this.getChunk(class_2338.method_10064((int)xC, (int)yC, (int)zC));
    }

    public short[] getChunk(long pos) {
        if (this.lastChunkPos != pos) {
            short[] chunk = (short[])this.map.get(pos);
            this.lastChunkPos = pos;
            this.lastChunk = chunk;
        }
        return this.lastChunk;
    }

    public short[] getOrCreateChunk(int xC, int yC, int zC) {
        return this.getOrCreateChunk(class_2338.method_10064((int)xC, (int)yC, (int)zC));
    }

    public short[] getOrCreateChunk(long pos) {
        if (this.lastChunk == null || this.lastChunkPos != pos) {
            short[] chunk = (short[])this.map.computeIfAbsent(pos, k -> new short[256]);
            this.lastChunkPos = pos;
            this.lastChunk = chunk;
        }
        return this.lastChunk;
    }

    public static interface ChunkConsumer {
        public void accept(int var1, int var2, int var3, short[] var4);
    }
}

