/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.clipboard;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.clipboard.Clipboard;
import com.moulberry.axiom.clipboard.Placement;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.clipboard.SelectionHistoryElement;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.packets.SupportedProtocol;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.restrictions.ClientRestrictions;
import com.moulberry.axiom.utils.EntityDataUtils;
import com.moulberry.axiom.world_modification.Dispatcher;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.joml.Matrix4f;

public class Selection {
    private static SelectionBuffer buffer = SelectionBuffer.EMPTY;
    private static boolean renderSelection = true;
    public static boolean copyWithAir = false;
    public static boolean copyWithEntities = false;
    public static boolean makeNextCopyIncludeAir = false;

    public static void render(class_4184 camera, long time, class_4587 matrices, Matrix4f projection, int effects) {
        if (!renderSelection) {
            return;
        }
        buffer.render(camera, time, matrices, projection, effects);
    }

    public static SelectionBuffer getSelectionBuffer() {
        return buffer;
    }

    public static boolean shouldRenderSelection() {
        return renderSelection;
    }

    public static void setShouldRenderSelection(boolean renderSelection) {
        Selection.renderSelection = renderSelection;
    }

    public static int selectedBlockCount() {
        return buffer.size();
    }

    public static boolean contains(int x, int y, int z) {
        if (!EditorUI.isActive()) {
            return true;
        }
        return buffer.contains(x, y, z);
    }

    public static void setBuffer(SelectionBuffer selectionBuffer) {
        selectionBuffer = selectionBuffer.optimize();
        if (buffer == (selectionBuffer = ClientRestrictions.constrainSelection(selectionBuffer))) {
            return;
        }
        buffer.close();
        buffer = selectionBuffer;
    }

    public static void setBufferWithHistory(SelectionBuffer selectionBuffer) {
        if (selectionBuffer.isEmpty()) {
            Selection.clearSelection();
            return;
        }
        class_2338 oldCenter = buffer.center();
        int oldCount = buffer.size();
        SelectionHistoryElement oldElement = buffer.createHistoryElement();
        Selection.setBuffer(selectionBuffer);
        buffer.pushActiveSelectionHistory(oldCenter, oldCount, oldElement);
    }

    public static void set(ChunkedBooleanRegion booleanRegion) {
        Selection.setBufferWithHistory(new SelectionBuffer.Set(booleanRegion));
    }

    public static void modify(UnaryOperator<ChunkedBooleanRegion> consumer) {
        Selection.setBuffer(buffer.modify(consumer, true));
    }

    public static void modifyWithHistory(UnaryOperator<ChunkedBooleanRegion> consumer, boolean history) {
        Selection.setBuffer(buffer.modify(consumer, history));
    }

    public static void move(int x, int y, int z, boolean history) {
        Selection.setBuffer(buffer.move(x, y, z, history));
    }

    public static void addAABB(class_2338 min2, class_2338 max2) {
        Selection.setBuffer(buffer.addAABB(min2, max2, true));
    }

    public static void subtractAABB(class_2338 min2, class_2338 max2) {
        Selection.setBuffer(buffer.subtractAABB(min2, max2, true));
    }

    public static void intersectAABB(class_2338 min2, class_2338 max2) {
        Selection.setBuffer(buffer.intersectAABB(min2, max2, true));
    }

    public static void addAABBWithHistory(class_2338 min2, class_2338 max2, boolean history) {
        Selection.setBuffer(buffer.addAABB(min2, max2, history));
    }

    public static void addSet(PositionSet positionSet) {
        if (positionSet.isEmpty()) {
            return;
        }
        Selection.setBuffer(buffer.addSet(positionSet, true));
    }

    public static void subtractSet(PositionSet positionSet) {
        if (positionSet.isEmpty()) {
            return;
        }
        Selection.setBuffer(buffer.subtractSet(positionSet, true));
    }

    public static void intersectSet(PositionSet positionSet) {
        Selection.setBuffer(buffer.intersectSet(positionSet, true));
    }

    public static void clearSelection() {
        Dispatcher.clearActiveSelectionHistory();
        Selection.setBuffer(SelectionBuffer.EMPTY);
    }

    public static void clearSelectionNoHistory() {
        Selection.setBuffer(SelectionBuffer.EMPTY);
    }

    public static UserAction.ActionResult callAction(UserAction action, Object object) {
        if (!EditorUI.isActive()) {
            return UserAction.ActionResult.NOT_HANDLED;
        }
        switch (action) {
            case COPY: {
                Selection.callCopy(makeNextCopyIncludeAir || copyWithAir, copyWithEntities);
                makeNextCopyIncludeAir = false;
                return UserAction.ActionResult.USED_STOP;
            }
            case DELETE: {
                Selection.callDelete();
                return UserAction.ActionResult.USED_STOP;
            }
            case CUT: {
                Selection.callCut(copyWithAir, copyWithEntities);
                return UserAction.ActionResult.USED_STOP;
            }
            case DUPLICATE: {
                Selection.callDuplicate(copyWithAir, copyWithEntities);
                return UserAction.ActionResult.USED_STOP;
            }
            case ENTER: {
                Selection.clearSelection();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    private static void callDelete() {
        buffer.callDelete();
        Selection.clearSelection();
    }

    private static void performCopyLikeAction(boolean copyAir, boolean copyEntities, boolean cut, boolean putInClipboard, boolean startPlacement) {
        copyEntities &= ClientEvents.serverSupportsProtocol(SupportedProtocol.REQUEST_ENTITY);
        class_2338 center = buffer.center();
        if (center != null) {
            class_638 level;
            if (Placement.INSTANCE.isPlacing()) {
                Placement.INSTANCE.stopPlacement();
            }
            float preferredYaw = 135.0f;
            class_1297 cameraEntity = class_310.method_1551().field_1719;
            if (cameraEntity != null) {
                double dx = cameraEntity.method_23317() - (double)center.method_10263();
                double dz = cameraEntity.method_23321() - (double)center.method_10260();
                preferredYaw = (float)(-Math.toDegrees(Math.atan2(dx, dz)));
            }
            float preferredYawFinal = preferredYaw;
            ArrayList<UUID> requestedEntities = new ArrayList<UUID>();
            if (copyEntities && (level = class_310.method_1551().field_1687) != null) {
                for (class_1297 entity : level.method_18112()) {
                    if (entity == null || entity.method_31481() || !entity.method_5864().method_5893() || !buffer.contains(entity.method_31477(), entity.method_31478(), entity.method_31479())) continue;
                    requestedEntities.add(entity.method_5667());
                }
            }
            buffer.callCopy(cut, copyAir).thenAccept(copyResult -> {
                if (copyResult != null && !copyResult.chunkedBlockRegion().isEmpty()) {
                    if (requestedEntities.isEmpty()) {
                        Selection.finalizeCopyLikeAction(copyResult, List.of(), copyAir, putInClipboard, startPlacement, preferredYawFinal, center);
                    } else {
                        Dispatcher.requestEntityData(requestedEntities, entityData -> {
                            ArrayList<class_2487> entities = new ArrayList<class_2487>(entityData.values());
                            for (class_2487 entity : entities) {
                                EntityDataUtils.offsetEntityRecursive(entity, class_243.method_24954((class_2382)copyResult.realOffset()));
                            }
                            Selection.finalizeCopyLikeAction(copyResult, entities, copyAir, putInClipboard, startPlacement, preferredYawFinal, center);
                        });
                    }
                }
            });
        }
        Selection.clearSelection();
    }

    private static void finalizeCopyLikeAction(SelectionBuffer.CopyResult copyResult, List<class_2487> entities, boolean includesAir, boolean putInClipboard, boolean startPlacement, float preferredYaw, class_2338 center) {
        if (putInClipboard) {
            Clipboard.INSTANCE.setClipboard(copyResult.chunkedBlockRegion(), copyResult.blockEntities(), entities, "", preferredYaw, includesAir);
        }
        if (startPlacement) {
            ChunkedBlockRegion blockBuffer = copyResult.chunkedBlockRegion();
            class_2338 newCenter = center.method_10069((blockBuffer.max().method_10263() + blockBuffer.min().method_10263()) / 2, (blockBuffer.max().method_10264() + blockBuffer.min().method_10264()) / 2, (blockBuffer.max().method_10260() + blockBuffer.min().method_10260()) / 2);
            String formattedCount = NumberFormat.getInstance().format(blockBuffer.count());
            String description = AxiomI18n.get("axiom.history_description.placed", formattedCount);
            Placement.INSTANCE.startPlacement(newCenter, blockBuffer, copyResult.blockEntities(), entities, includesAir, description);
        }
    }

    private static void callCut(boolean copyAir, boolean copyEntities) {
        Selection.performCopyLikeAction(copyAir, copyEntities, true, Axiom.configuration.internal.cutAlsoCopiesToClipboard, true);
    }

    public static void callCopy(boolean copyAir, boolean copyEntities) {
        Selection.performCopyLikeAction(copyAir, copyEntities, false, true, false);
    }

    private static void callDuplicate(boolean copyAir, boolean copyEntities) {
        Selection.performCopyLikeAction(copyAir, copyEntities, false, false, true);
    }
}

