/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.capabilities;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.VersionUtilsClient;
import com.moulberry.axiom.buildertools.BuilderToolManager;
import com.moulberry.axiom.buildertools.MirrorBuilderTool;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.render.Shapes;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.utils.BlockHelper;
import com.moulberry.axiom.utils.ChatUtils;
import com.moulberry.axiom.utils.RenderHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class BuildSymmetry {
    private static class_2338 symmetryPoint = null;
    private static boolean flipX = false;
    private static boolean flipY = false;
    private static boolean flipZ = false;
    private static boolean rotY = false;

    public static boolean isActive() {
        return symmetryPoint != null && BuilderToolManager.selectedToolIs(MirrorBuilderTool.class);
    }

    public static void clear() {
        symmetryPoint = null;
        rotY = false;
        flipZ = false;
        flipY = false;
        flipX = false;
    }

    public static void setSymmetryPoint(class_243 vec) {
        symmetryPoint = new class_2338((int)Math.round(vec.field_1352 * 2.0), (int)Math.round(vec.field_1351 * 2.0), (int)Math.round(vec.field_1350 * 2.0));
    }

    @Nullable
    public static class_243 getSymmetryPoint() {
        if (symmetryPoint == null) {
            return null;
        }
        return new class_243((double)((float)symmetryPoint.method_10263() * 0.5f), (double)((float)symmetryPoint.method_10264() * 0.5f), (double)((float)symmetryPoint.method_10260() * 0.5f));
    }

    public static boolean toggleRotY() {
        rotY = !rotY;
        return rotY;
    }

    public static boolean toggleFlipX() {
        flipX = !flipX;
        return flipX;
    }

    public static boolean toggleFlipY() {
        flipY = !flipY;
        return flipY;
    }

    public static boolean toggleFlipZ() {
        flipZ = !flipZ;
        return flipZ;
    }

    public static Map<class_2338, class_2680> applySymmetry(Map<class_2338, class_2680> original) {
        int x;
        class_2338 pos;
        if (!BuildSymmetry.isActive()) {
            return original;
        }
        LinkedHashMap<Object, Object> mirrored = new LinkedHashMap<class_2338, class_2680>();
        if (!(flipX || flipY || flipZ || rotY)) {
            return original;
        }
        boolean doFlipX = flipX;
        boolean doFlipY = flipY;
        boolean doFlipZ = flipZ;
        int symmX = symmetryPoint.method_10263();
        int symmY = symmetryPoint.method_10264();
        int symmZ = symmetryPoint.method_10260();
        if (rotY) {
            if (doFlipX && doFlipZ) {
                doFlipZ = false;
            }
            if ((symmX + symmZ & 1) != 0) {
                if (Math.abs(symmZ) > Math.abs(symmX)) {
                    symmZ = (int)((float)symmZ - Math.signum(symmZ));
                } else if (symmX != 0) {
                    symmX = (int)((float)symmX - Math.signum(symmX));
                }
            }
            for (Map.Entry<class_2338, class_2680> entry : original.entrySet()) {
                pos = entry.getKey();
                x = pos.method_10263();
                int z = pos.method_10260();
                int newX = -Math.floorDiv(-(z * 2 - symmZ + symmX), 2);
                int newZ = Math.floorDiv(symmX + symmZ - x * 2 - 2, 2);
                if (newX != x || newZ != z) {
                    if (entry.getValue().method_26215()) {
                        mirrored.put(new class_2338(newX, pos.method_10264(), newZ), class_2246.field_10124.method_9564());
                    } else {
                        mirrored.putIfAbsent(new class_2338(newX, pos.method_10264(), newZ), BlockHelper.rotateY(entry.getValue(), class_2470.field_11465));
                    }
                }
                newX = symmX - x - 1;
                newZ = symmZ - z - 1;
                if (newX != x || newZ != z) {
                    if (entry.getValue().method_26215()) {
                        mirrored.put(new class_2338(newX, pos.method_10264(), newZ), class_2246.field_10124.method_9564());
                    } else {
                        mirrored.putIfAbsent(new class_2338(newX, pos.method_10264(), newZ), BlockHelper.rotateY(entry.getValue(), class_2470.field_11464));
                    }
                }
                newX = Math.floorDiv(symmZ + symmX - z * 2 - 2, 2);
                newZ = -Math.floorDiv(-(x * 2 - symmX + symmZ), 2);
                if (newX == x && newZ == z) continue;
                if (entry.getValue().method_26215()) {
                    mirrored.put(new class_2338(newX, pos.method_10264(), newZ), class_2246.field_10124.method_9564());
                    continue;
                }
                mirrored.putIfAbsent(new class_2338(newX, pos.method_10264(), newZ), BlockHelper.rotateY(entry.getValue(), class_2470.field_11463));
            }
        }
        if (doFlipX) {
            if (!mirrored.isEmpty()) {
                mirrored.putAll(original);
                original = mirrored;
                mirrored = new LinkedHashMap();
            }
            for (Map.Entry<class_2338, class_2680> entry : original.entrySet()) {
                pos = entry.getKey();
                x = pos.method_10263();
                int newX = symmX - x - 1;
                if (newX == x) continue;
                if (entry.getValue().method_26215()) {
                    mirrored.put(new class_2338(newX, pos.method_10264(), pos.method_10260()), class_2246.field_10124.method_9564());
                    continue;
                }
                mirrored.putIfAbsent(new class_2338(newX, pos.method_10264(), pos.method_10260()), BlockHelper.flipX(entry.getValue()));
            }
        }
        if (doFlipZ) {
            if (!mirrored.isEmpty()) {
                mirrored.putAll(original);
                original = mirrored;
                mirrored = new LinkedHashMap();
            }
            for (Map.Entry<class_2338, class_2680> entry : original.entrySet()) {
                pos = entry.getKey();
                int z = pos.method_10260();
                int newZ = symmZ - z - 1;
                if (newZ == z) continue;
                if (entry.getValue().method_26215()) {
                    mirrored.put(new class_2338(pos.method_10263(), pos.method_10264(), newZ), class_2246.field_10124.method_9564());
                    continue;
                }
                mirrored.putIfAbsent(new class_2338(pos.method_10263(), pos.method_10264(), newZ), BlockHelper.flipZ(entry.getValue()));
            }
        }
        if (doFlipY) {
            if (!mirrored.isEmpty()) {
                mirrored.putAll(original);
                original = mirrored;
                mirrored = new LinkedHashMap();
            }
            for (Map.Entry<class_2338, class_2680> entry : original.entrySet()) {
                pos = entry.getKey();
                int y = pos.method_10264();
                int newY = symmY - y - 1;
                if (newY == y) continue;
                if (entry.getValue().method_26215()) {
                    mirrored.put(new class_2338(pos.method_10263(), newY, pos.method_10260()), class_2246.field_10124.method_9564());
                    continue;
                }
                mirrored.putIfAbsent(new class_2338(pos.method_10263(), newY, pos.method_10260()), BlockHelper.flipY(entry.getValue()));
            }
        }
        mirrored.putAll(original);
        return mirrored;
    }

    public static void renderWorld(class_4184 camera, long time, class_4587 matrices, Matrix4f projection) {
        if (symmetryPoint != null && BuildSymmetry.isActive()) {
            class_243 tip;
            class_243 base;
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                BuildSymmetry.clear();
                return;
            }
            int symmetryRange = Axiom.configuration.builderTools.symmetryRange;
            if (player.method_5649((double)((float)symmetryPoint.method_10263() * 0.5f), player.method_23318(), (double)((float)symmetryPoint.method_10260() * 0.5f)) > (double)(symmetryRange * symmetryRange)) {
                ChatUtils.warning("Build Symmetry disabled due to travelling more than " + symmetryRange + " blocks away");
                BuildSymmetry.clear();
                return;
            }
            if (class_310.method_1551().field_1690.field_1842) {
                return;
            }
            matrices.method_22903();
            matrices.method_22904((double)symmetryPoint.method_10263() * 0.5 - 0.1 - camera.method_19326().field_1352, (double)symmetryPoint.method_10264() * 0.5 - 0.1 - camera.method_19326().field_1351, (double)symmetryPoint.method_10260() * 0.5 - 0.1 - camera.method_19326().field_1350);
            RenderHelper.tryApplyModelViewMatrix();
            VertexConsumerProvider provider = VertexConsumerProvider.shared();
            Matrix4f pose = matrices.method_23760().method_23761();
            class_287 bufferBuilder = provider.begin(class_293.class_5596.field_27379, class_290.field_1576);
            if (!(flipX || flipY || flipZ || rotY)) {
                Shapes.shadedBoxTriangles(bufferBuilder, pose, 0.2f, 0.2f, 0.2f, -6250336);
            } else {
                Shapes.shadedBoxTriangles(bufferBuilder, pose, 0.2f, 0.2f, 0.2f, -256);
            }
            if (flipX) {
                base = new class_243(0.5, (double)0.1f, (double)0.1f);
                tip = new class_243((double)0.8f, (double)0.1f, (double)0.1f);
                Shapes.shadedCone(bufferBuilder, pose, base, tip, 0, 0.2f, -65536);
                base = new class_243((double)-0.3f, (double)0.1f, (double)0.1f);
                tip = new class_243((double)-0.6f, (double)0.1f, (double)0.1f);
                Shapes.shadedCone(bufferBuilder, pose, base, tip, 0, 0.2f, -65536);
            }
            if (flipY) {
                base = new class_243((double)0.1f, 0.5, (double)0.1f);
                tip = new class_243((double)0.1f, (double)0.8f, (double)0.1f);
                Shapes.shadedCone(bufferBuilder, pose, base, tip, 1, 0.2f, -16711936);
                base = new class_243((double)0.1f, (double)-0.3f, (double)0.1f);
                tip = new class_243((double)0.1f, (double)-0.6f, (double)0.1f);
                Shapes.shadedCone(bufferBuilder, pose, base, tip, 1, 0.2f, -16711936);
            }
            if (flipZ) {
                base = new class_243((double)0.1f, (double)0.1f, 0.5);
                tip = new class_243((double)0.1f, (double)0.1f, (double)0.8f);
                Shapes.shadedCone(bufferBuilder, pose, base, tip, 2, 0.2f, -16776961);
                base = new class_243((double)0.1f, (double)0.1f, (double)-0.3f);
                tip = new class_243((double)0.1f, (double)0.1f, (double)-0.6f);
                Shapes.shadedCone(bufferBuilder, pose, base, tip, 2, 0.2f, -16776961);
            }
            AxiomRenderer.setShaderColour(0.8f, 0.8f, 0.8f, 0.5f);
            class_287.class_7433 box = VersionUtilsClient.helperOldBufferBuilderEndOrDiscard(bufferBuilder);
            AxiomRenderer.renderPipeline(AxiomRenderPipelines.POSITION_COLOR_IGNORE_DEPTH, null, box, false);
            if (rotY) {
                bufferBuilder = provider.begin(class_293.class_5596.field_27377, class_290.field_29337);
                AxiomRenderer.setLineWidthLegacy(RenderHelper.baseLineWidth);
                float lastX = 0.0f;
                float lastZ = 0.0f;
                for (int i = 0; i <= 36; ++i) {
                    double angle = Math.toRadians(i * 10);
                    double sin2 = Math.sin(angle);
                    double cos2 = Math.cos(angle);
                    float x = (float)sin2 * 0.35f;
                    float z = (float)cos2 * 0.35f;
                    if (i > 0) {
                        float nx = x - lastX;
                        float nz = z - lastZ;
                        float norm = 1.0f / (float)Math.sqrt(nx * nx + nz * nz);
                        VersionUtilsClient.legacySetLineWidthIgnored(VersionUtilsClient.helperOldAddVertex((class_4588)bufferBuilder, pose, lastX + 0.1f, 0.1f, lastZ + 0.1f).method_39415(-16711936).method_23763(matrices.method_23760().method_23762(), nx *= norm, 0.0f, nz *= norm), RenderHelper.baseLineWidth);
                        VersionUtilsClient.legacySetLineWidthIgnored(VersionUtilsClient.helperOldAddVertex((class_4588)bufferBuilder, pose, x + 0.1f, 0.1f, z + 0.1f).method_39415(-16711936).method_23763(matrices.method_23760().method_23762(), nx, 0.0f, nz), RenderHelper.baseLineWidth);
                        VersionUtilsClient.legacySetLineWidthIgnored(VersionUtilsClient.helperOldAddVertex((class_4588)bufferBuilder, pose, lastX * 0.8f + 0.1f, 0.1f, lastZ * 0.8f + 0.1f).method_39415(-16711936).method_23763(matrices.method_23760().method_23762(), nx, 0.0f, nz), RenderHelper.baseLineWidth);
                        VersionUtilsClient.legacySetLineWidthIgnored(VersionUtilsClient.helperOldAddVertex((class_4588)bufferBuilder, pose, x * 0.8f + 0.1f, 0.1f, z * 0.8f + 0.1f).method_39415(-16711936).method_23763(matrices.method_23760().method_23762(), nx, 0.0f, nz), RenderHelper.baseLineWidth);
                    }
                    lastX = x;
                    lastZ = z;
                }
                class_287.class_7433 meshData = VersionUtilsClient.helperOldBufferBuilderEndOrDiscard(bufferBuilder);
                AxiomRenderer.setShaderColour(0.8f, 0.8f, 0.8f, 0.5f);
                AxiomRenderer.renderPipeline(AxiomRenderPipelines.LINES_WITHOUT_WRITE_DEPTH, null, meshData, false);
                AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
                AxiomRenderer.renderPipeline(AxiomRenderPipelines.LINES_WITHOUT_WRITE_DEPTH, null, meshData, true);
            }
            AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
            AxiomRenderer.renderPipeline(AxiomRenderPipelines.POSITION_COLOR, null, box, true);
            matrices.method_22909();
        }
    }
}

