/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.buildertools;

import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.buildertools.BuilderTool;
import com.moulberry.axiom.buildertools.BuilderToolManager;
import com.moulberry.axiom.buildertools.BuilderToolSelectionState;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.hooks.ScreenRenderHook;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.packets.AxiomServerboundSpawnEntity;
import com.moulberry.axiom.packets.SupportedProtocol;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.utils.RegionHelper;
import com.moulberry.axiom.world_modification.HistoryEntry;
import com.moulberry.axiom.world_modification.undo.DeleteEntityAdditionalUndoOperation;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1530;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Matrix4f;

public class StackBuilderTool
implements BuilderTool {
    private final BuilderToolSelectionState selectionState = new BuilderToolSelectionState();
    private SelectionBuffer selectionBuffer = null;
    private class_2338.class_2339 stackDirections = null;
    private final ChunkedBlockRegion blockRegion = new ChunkedBlockRegion();

    @Override
    public void renderScreen(class_332 guiGraphics, int screenWidth, int screenHeight, float partialTick) {
        if (this.stackDirections != null) {
            BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.cancel"), class_310.method_1551().field_1690.field_1886, 0);
            BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.confirm"), class_310.method_1551().field_1690.field_1904, 1);
            BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.stack.stack_to"), class_310.method_1551().field_1690.field_1871, 2);
            return;
        }
        this.selectionState.renderScreen(guiGraphics, screenWidth, screenHeight);
    }

    @Override
    public void handleInput(boolean nudgeForwards, boolean nudgeBackwards, boolean delete) {
        if (nudgeForwards) {
            this.nudge(1);
        }
        if (nudgeBackwards) {
            this.nudge(-1);
        }
        if (delete) {
            if (this.stackDirections == null) {
                this.selectionState.createSelectionBuffer().callDelete(HistoryEntry.MODIFIER_CAN_BE_UNDONE_INGAME);
            }
            this.reset(false);
        }
    }

    @Override
    public void renderWorld(class_4184 camera, long time, class_4587 matrices, Matrix4f projection) {
        if (this.stackDirections != null) {
            this.blockRegion.render(camera, class_243.field_1353, matrices, projection, 0.8f, 0.0f);
            class_2338 min2 = this.selectionBuffer.min();
            class_2338 max2 = this.selectionBuffer.max();
            int minX = min2.method_10263();
            int minY = min2.method_10264();
            int minZ = min2.method_10260();
            int maxX = max2.method_10263();
            int maxY = max2.method_10264();
            int maxZ = max2.method_10260();
            int stackDX = maxX - minX + 1;
            int stackDY = maxY - minY + 1;
            int stackDZ = maxZ - minZ + 1;
            if (this.stackDirections.method_10263() < 0) {
                minX += stackDX * this.stackDirections.method_10263();
            } else {
                maxX += stackDX * this.stackDirections.method_10263();
            }
            if (this.stackDirections.method_10264() < 0) {
                minY += stackDY * this.stackDirections.method_10264();
            } else {
                maxY += stackDY * this.stackDirections.method_10264();
            }
            if (this.stackDirections.method_10260() < 0) {
                minZ += stackDZ * this.stackDirections.method_10260();
            } else {
                maxZ += stackDZ * this.stackDirections.method_10260();
            }
            BuilderTool.renderBoxWithArrow(BuilderTool.calculateDirection(), camera, time, matrices, projection, minX, minY, minZ, maxX, maxY, maxZ);
            this.selectionState.renderWorldMagicSelect(camera, time, matrices, projection);
            return;
        }
        this.selectionState.renderWorld(camera, time, matrices, projection);
    }

    @Override
    public boolean setPos1(class_2338 position) {
        if (this.stackDirections == null) {
            this.selectionState.setPos1(position);
            this.showTextInActionBar();
        }
        return true;
    }

    @Override
    public boolean setPos2(class_2338 position) {
        if (this.stackDirections == null) {
            this.selectionState.setPos2(position);
            this.showTextInActionBar();
        }
        return true;
    }

    @Override
    public void leftClick(class_239 hitResult) {
        if (this.stackDirections != null) {
            this.reset(false);
        } else if (hitResult.method_17783() == class_239.class_240.field_1332 && hitResult instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)hitResult;
            this.selectionState.leftClick(blockHitResult);
            this.showTextInActionBar();
        }
    }

    @Override
    public void rightClick(class_239 hitResult) {
        if (this.stackDirections != null) {
            this.reset(true);
        } else if (hitResult.method_17783() == class_239.class_240.field_1332 && hitResult instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)hitResult;
            this.selectionState.rightClick(blockHitResult);
            this.showTextInActionBar();
        }
    }

    @Override
    public void middleClick(class_239 hitResult) {
        if (hitResult.method_17783() == class_239.class_240.field_1332 && hitResult instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)hitResult;
            class_2338 blockPos = blockHitResult.method_17777();
            if (this.stackDirections != null) {
                class_2338 newStackDirections = new class_2338(this.calculateStackToForAxis(blockPos, class_2350.class_2351.field_11048), this.calculateStackToForAxis(blockPos, class_2350.class_2351.field_11052), this.calculateStackToForAxis(blockPos, class_2350.class_2351.field_11051));
                if (!this.stackDirections.equals((Object)newStackDirections)) {
                    this.stackDirections.method_10101((class_2382)newStackDirections);
                    this.recalculate((class_1937)class_310.method_1551().field_1687);
                }
                return;
            }
            this.selectionState.middleClick(blockHitResult);
            this.showTextInActionBar();
        }
    }

    private int calculateStackToForAxis(class_2338 blockPos, class_2350.class_2351 axis) {
        int min2 = this.selectionBuffer.min().method_30558(axis);
        int max2 = this.selectionBuffer.max().method_30558(axis);
        int size = max2 - min2 + 1;
        if (blockPos.method_30558(axis) < min2) {
            int delta = blockPos.method_30558(axis) - min2;
            return (delta - (size - 1)) / size;
        }
        if (blockPos.method_30558(axis) > max2) {
            int delta = blockPos.method_30558(axis) - max2;
            return (delta + (size - 1)) / size;
        }
        return 0;
    }

    private void apply() {
        if (this.stackDirections != null && (this.stackDirections.method_10263() != 0 || this.stackDirections.method_10264() != 0 || this.stackDirections.method_10260() != 0)) {
            int posMaxZ;
            int posMaxY;
            int posMaxX;
            int posMinZ;
            int posMinY;
            int posMinX;
            class_238 bounds;
            List entities;
            String description = AxiomI18n.get("axiom.history_description.stacked", NumberFormat.getInstance().format(this.blockRegion.count()));
            DeleteEntityAdditionalUndoOperation additionalUndoOperation = null;
            if (this.blockRegion.isEmpty()) {
                return;
            }
            class_2338 pos1 = this.selectionBuffer.min();
            class_2338 pos2 = this.selectionBuffer.max();
            ArrayList<AxiomServerboundSpawnEntity.SpawnEntry> spawnEntries = new ArrayList<AxiomServerboundSpawnEntity.SpawnEntry>();
            class_638 level = class_310.method_1551().field_1687;
            if (level != null && ClientEvents.serverSupportsProtocol(SupportedProtocol.CREATE_ENTITY) && BuilderToolManager.copyEntities && !(entities = level.method_8333((class_1297)class_310.method_1551().field_1724, bounds = new class_238(new class_243((double)(posMinX = Math.min(pos1.method_10263(), pos2.method_10263())), (double)(posMinY = Math.min(pos1.method_10264(), pos2.method_10264())), (double)(posMinZ = Math.min(pos1.method_10260(), pos2.method_10260()))), new class_243((double)((posMaxX = Math.max(pos1.method_10263(), pos2.method_10263())) + 1), (double)((posMaxY = Math.max(pos1.method_10264(), pos2.method_10264())) + 1), (double)((posMaxZ = Math.max(pos1.method_10260(), pos2.method_10260())) + 1))), BuilderTool::shouldEntityByCopied)).isEmpty()) {
                ArrayList<UUID> uuids = new ArrayList<UUID>();
                class_2487 emptyTag = new class_2487();
                int stackDX = (posMaxX - posMinX + 1) * (int)Math.signum(this.stackDirections.method_10263());
                int stackDY = (posMaxY - posMinY + 1) * (int)Math.signum(this.stackDirections.method_10264());
                int stackDZ = (posMaxZ - posMinZ + 1) * (int)Math.signum(this.stackDirections.method_10260());
                int stackMaxX = Math.abs(this.stackDirections.method_10263());
                int stackMaxY = Math.abs(this.stackDirections.method_10264());
                int stackMaxZ = Math.abs(this.stackDirections.method_10260());
                for (class_1297 entity : entities) {
                    class_243 entityPos;
                    if (entity instanceof class_1530) {
                        class_1530 hangingEntity = (class_1530)entity;
                        entityPos = class_243.method_24953((class_2382)hangingEntity.method_6896());
                    } else {
                        entityPos = entity.method_19538();
                    }
                    double x = entityPos.field_1352;
                    double y = entityPos.field_1351;
                    double z = entityPos.field_1350;
                    for (int stackX = 0; stackX <= stackMaxX; ++stackX) {
                        for (int stackY = 0; stackY <= stackMaxY; ++stackY) {
                            for (int stackZ = 0; stackZ <= stackMaxZ; ++stackZ) {
                                if (stackX == 0 && stackY == 0 && stackZ == 0) continue;
                                class_243 position = new class_243(x + (double)(stackX * stackDX), y + (double)(stackY * stackDY), z + (double)(stackZ * stackDZ));
                                UUID uuid = UUID.randomUUID();
                                spawnEntries.add(new AxiomServerboundSpawnEntity.SpawnEntry(uuid, position, entity.method_36454(), entity.method_36455(), entity.method_5667(), emptyTag));
                                uuids.add(uuid);
                            }
                        }
                    }
                }
                additionalUndoOperation = new DeleteEntityAdditionalUndoOperation(uuids);
            }
            int flags = HistoryEntry.MODIFIER_CAN_BE_UNDONE_INGAME;
            if (BuilderToolManager.keepExisting) {
                flags |= HistoryEntry.MODIFIER_KEEP_EXISTING;
            }
            int minX = Math.min(pos1.method_10263(), pos2.method_10263());
            int minY = Math.min(pos1.method_10264(), pos2.method_10264());
            int minZ = Math.min(pos1.method_10260(), pos2.method_10260());
            int sizeX = Math.abs(pos1.method_10263() - pos2.method_10263()) + 1;
            int sizeY = Math.abs(pos1.method_10264() - pos2.method_10264()) + 1;
            int sizeZ = Math.abs(pos1.method_10260() - pos2.method_10260()) + 1;
            RegionHelper.pushBlockRegionChangeWithNBT(this.blockRegion, description, flags, pos -> {
                int x = class_2338.method_10061((long)pos);
                int y = class_2338.method_10071((long)pos);
                int z = class_2338.method_10083((long)pos);
                x -= minX;
                y -= minY;
                z -= minZ;
                y %= sizeY;
                z %= sizeZ;
                if ((x %= sizeX) < 0) {
                    x += sizeX;
                }
                if (y < 0) {
                    y += sizeY;
                }
                if (z < 0) {
                    z += sizeZ;
                }
                return class_2338.method_10064((int)(x + minX), (int)(y + minY), (int)(z + minZ));
            }, additionalUndoOperation);
            if (!spawnEntries.isEmpty()) {
                new AxiomServerboundSpawnEntity(spawnEntries).send();
            }
        }
    }

    @Override
    public boolean scroll(int scroll) {
        if (!this.selectionState.hasSelection()) {
            return false;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return false;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        class_2350 dir = BuilderTool.calculateDirection();
        if (this.stackDirections == null) {
            if (ClientEvents.builderToolNudgeScrollKeyBind.method_1434()) {
                this.nudge(scroll);
                return true;
            }
            this.stackDirections = new class_2338.class_2339();
        }
        this.stackDirections.method_10104(dir, scroll);
        this.showTextInActionBar();
        this.recalculate((class_1937)level);
        return true;
    }

    private void recalculate(class_1937 level) {
        this.blockRegion.clear();
        if (this.selectionBuffer != null) {
            this.selectionBuffer.close();
        }
        this.selectionBuffer = this.selectionState.createSelectionBuffer();
        class_2338 min2 = this.selectionBuffer.min();
        class_2338 max2 = this.selectionBuffer.max();
        if (this.selectionBuffer.isEmpty() || min2 == null || max2 == null) {
            return;
        }
        int stackDX = (max2.method_10263() - min2.method_10263() + 1) * (int)Math.signum(this.stackDirections.method_10263());
        int stackDY = (max2.method_10264() - min2.method_10264() + 1) * (int)Math.signum(this.stackDirections.method_10264());
        int stackDZ = (max2.method_10260() - min2.method_10260() + 1) * (int)Math.signum(this.stackDirections.method_10260());
        int stackMaxX = Math.abs(this.stackDirections.method_10263());
        int stackMaxY = Math.abs(this.stackDirections.method_10264());
        int stackMaxZ = Math.abs(this.stackDirections.method_10260());
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        this.selectionBuffer.forEach((x, y, z) -> {
            class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
            if (BuilderToolManager.copyAir || !blockState.method_26215()) {
                for (int stackX = 0; stackX <= stackMaxX; ++stackX) {
                    for (int stackY = 0; stackY <= stackMaxY; ++stackY) {
                        for (int stackZ = 0; stackZ <= stackMaxZ; ++stackZ) {
                            if (stackX == 0 && stackY == 0 && stackZ == 0) continue;
                            this.blockRegion.addBlock(x + stackX * stackDX, y + stackY * stackDY, z + stackZ * stackDZ, blockState);
                        }
                    }
                }
            }
        });
    }

    private void nudge(int amount) {
        if (this.stackDirections != null) {
            return;
        }
        this.selectionState.nudge(amount);
        this.showTextInActionBar();
    }

    private void showTextInActionBar() {
        if (this.stackDirections != null) {
            ScreenRenderHook.setOverlayText((class_2561)class_2561.method_43470((String)"Stacks: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(this.stackDirections.method_10263() + " ")).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)(this.stackDirections.method_10264() + " ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)("" + this.stackDirections.method_10260())).method_27692(class_124.field_1075)));
        } else {
            this.selectionState.showTextInActionBar();
        }
    }

    @Override
    public boolean shouldRenderBlockOutline(class_2338 blockPos) {
        if (this.stackDirections != null) {
            return false;
        }
        return !this.selectionState.selectionContains(blockPos);
    }

    @Override
    public String getName() {
        return AxiomI18n.get("axiom.buildertool.stack");
    }

    @Override
    public boolean canBeReset() {
        return this.selectionState.hasSelection() || this.stackDirections != null;
    }

    @Override
    public void reset(boolean apply) {
        if (apply && this.selectionState.hasSelection() && this.stackDirections != null) {
            this.apply();
        }
        this.selectionState.resetSelection();
        this.blockRegion.clear();
        this.stackDirections = null;
        if (this.selectionBuffer != null) {
            this.selectionBuffer.close();
            this.selectionBuffer = null;
        }
    }

    @Override
    public BuilderToolSelectionState.Restore getSelectionRestore() {
        return this.selectionState.getSelectionRestore();
    }

    @Override
    public void applySelectionRestore(BuilderToolSelectionState.Restore restore) {
        this.selectionState.restoreFrom(restore);
    }

    @Override
    public EnumSet<AxiomPermission> requiredPermissions() {
        return EnumSet.of(AxiomPermission.BUILDERTOOL_STACK, AxiomPermission.BUILD_SECTION);
    }
}

