/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.buildertools;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.buildertools.BuilderTool;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.configuration.BuilderToolMiddleClick;
import com.moulberry.axiom.hooks.ScreenRenderHook;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.EffectRenderer;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.restrictions.ClientRestrictions;
import com.moulberry.axiom.tools.magic_select.MagicSelectionPreciseTask;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class BuilderToolSelectionState {
    private class_2338.class_2339 pos1 = null;
    private class_2338.class_2339 pos2 = null;
    private ChunkedBooleanRegion magicSelectRegion = null;

    public void renderWorld(class_4184 camera, long time, class_4587 matrices, Matrix4f projection) {
        if (this.pos1 != null && this.pos2 != null) {
            int minX = Math.min(this.pos1.method_10263(), this.pos2.method_10263());
            int minY = Math.min(this.pos1.method_10264(), this.pos2.method_10264());
            int minZ = Math.min(this.pos1.method_10260(), this.pos2.method_10260());
            int maxX = Math.max(this.pos1.method_10263(), this.pos2.method_10263());
            int maxY = Math.max(this.pos1.method_10264(), this.pos2.method_10264());
            int maxZ = Math.max(this.pos1.method_10260(), this.pos2.method_10260());
            BuilderTool.renderBoxWithArrow(BuilderTool.calculateDirection(), camera, time, matrices, projection, minX, minY, minZ, maxX, maxY, maxZ);
        } else if (this.pos1 != null) {
            int x = this.pos1.method_10263();
            int y = this.pos1.method_10264();
            int z = this.pos1.method_10260();
            EffectRenderer.renderBoundingBox(camera, time, matrices, new class_243((double)x, (double)y, (double)z), new class_243((double)(x + 1), (double)(y + 1), (double)(z + 1)), 3);
        }
        this.renderWorldMagicSelect(camera, time, matrices, projection);
    }

    public void renderWorldMagicSelect(class_4184 camera, long time, class_4587 matrices, Matrix4f projection) {
        if (this.magicSelectRegion != null) {
            this.magicSelectRegion.render(camera, class_243.field_1353, matrices, projection, time, 7);
        }
    }

    public void renderScreen(class_332 guiGraphics, int screenWidth, int screenHeight) {
        if (this.hasSelection()) {
            if (ClientEvents.builderToolNudgeScrollKeyBind.method_1434()) {
                BuilderTool.renderScrollHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.scroll_nudge"), 0);
            } else {
                BuilderTool.renderScrollHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.move.scroll"), 0);
                if (Axiom.configuration.builderTools.middleClick == BuilderToolMiddleClick.EXTEND_SELECT) {
                    BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.scroll_extend"), class_310.method_1551().field_1690.field_1871, 1);
                }
            }
        } else {
            if (this.pos1 == null) {
                BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.first_point"), class_310.method_1551().field_1690.field_1886, 0);
            } else {
                BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.second_point"), class_310.method_1551().field_1690.field_1904, 0);
            }
            if (Axiom.configuration.builderTools.middleClick == BuilderToolMiddleClick.MAGIC_SELECT) {
                BuilderTool.renderKeybindHelp(guiGraphics, screenWidth, screenHeight, AxiomI18n.get("axiom.buildertool.scroll_magic"), class_310.method_1551().field_1690.field_1871, 1);
            }
        }
    }

    public SelectionBuffer createSelectionBuffer() {
        SelectionBuffer selection = SelectionBuffer.EMPTY;
        if (this.pos1 != null && this.pos2 != null && BuilderTool.applyLimitBounds(this.pos1, this.pos2)) {
            int minX = Math.min(this.pos1.method_10263(), this.pos2.method_10263());
            int minY = Math.min(this.pos1.method_10264(), this.pos2.method_10264());
            int minZ = Math.min(this.pos1.method_10260(), this.pos2.method_10260());
            int maxX = Math.max(this.pos1.method_10263(), this.pos2.method_10263());
            int maxY = Math.max(this.pos1.method_10264(), this.pos2.method_10264());
            int maxZ = Math.max(this.pos1.method_10260(), this.pos2.method_10260());
            selection = selection.addAABB(new class_2338(minX, minY, minZ), new class_2338(maxX, maxY, maxZ), false);
        }
        if (this.magicSelectRegion != null) {
            selection = selection.addSet(this.magicSelectRegion.unsafeGetPositionSet(), false);
        }
        return ClientRestrictions.constrainSelection(selection);
    }

    public void nudge(int amount) {
        class_2350 direction = BuilderTool.calculateDirection();
        if (this.pos1 != null && this.pos2 != null) {
            boolean facingNegative;
            class_2350.class_2351 axis = direction.method_10166();
            boolean bl = facingNegative = direction.method_10171() == class_2350.class_2352.field_11060;
            if (this.pos1.method_30558(axis) == this.pos2.method_30558(axis) && amount < 0) {
                this.pos1.method_10104(direction, amount);
                this.pos2.method_10104(direction, amount);
            } else if (this.pos1.method_30558(axis) < this.pos2.method_30558(axis) == facingNegative) {
                this.pos1.method_10104(direction, amount);
            } else {
                this.pos2.method_10104(direction, amount);
            }
        } else if (this.pos1 != null) {
            this.pos1.method_10104(direction, amount);
        } else if (this.pos2 != null) {
            this.pos2.method_10104(direction, amount);
        }
    }

    public void showTextInActionBar() {
        if (this.pos1 != null && this.pos2 != null) {
            int sizeX = Math.abs(this.pos1.method_10263() - this.pos2.method_10263()) + 1;
            int sizeY = Math.abs(this.pos1.method_10264() - this.pos2.method_10264()) + 1;
            int sizeZ = Math.abs(this.pos1.method_10260() - this.pos2.method_10260()) + 1;
            ScreenRenderHook.setOverlayText((class_2561)class_2561.method_43470((String)"Size: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(sizeX + " ")).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)(sizeY + " ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)("" + sizeZ)).method_27692(class_124.field_1075)));
        } else if (this.magicSelectRegion != null) {
            String text = "Size: " + this.magicSelectRegion.count() + " blocks";
            ScreenRenderHook.setOverlayText((class_2561)class_2561.method_43470((String)text).method_27692(class_124.field_1054));
        }
    }

    public boolean hasSelection() {
        return this.pos1 != null && this.pos2 != null || this.magicSelectRegion != null;
    }

    public void resetSelection() {
        this.pos1 = null;
        this.pos2 = null;
        if (this.magicSelectRegion != null) {
            this.magicSelectRegion.close();
            this.magicSelectRegion = null;
        }
    }

    public boolean selectionContains(class_2338 blockPos) {
        if (this.magicSelectRegion != null && this.magicSelectRegion.contains(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260())) {
            return true;
        }
        if (this.pos1 != null) {
            if (this.pos2 != null) {
                int minX = Math.min(this.pos1.method_10263(), this.pos2.method_10263());
                int minY = Math.min(this.pos1.method_10264(), this.pos2.method_10264());
                int minZ = Math.min(this.pos1.method_10260(), this.pos2.method_10260());
                int maxX = Math.max(this.pos1.method_10263(), this.pos2.method_10263());
                int maxY = Math.max(this.pos1.method_10264(), this.pos2.method_10264());
                int maxZ = Math.max(this.pos1.method_10260(), this.pos2.method_10260());
                int x = blockPos.method_10263();
                int y = blockPos.method_10264();
                int z = blockPos.method_10260();
                return x >= minX && x <= maxX && y >= minY && y <= maxY && z >= minZ && z <= maxZ;
            }
            return blockPos.equals((Object)this.pos1);
        }
        if (this.pos2 != null) {
            return blockPos.equals((Object)this.pos2);
        }
        return false;
    }

    public void setPos1(class_2338 blockPos) {
        this.pos1 = blockPos.method_25503();
    }

    public void setPos2(class_2338 blockPos) {
        this.pos2 = blockPos.method_25503();
    }

    public void leftClick(class_3965 blockHitResult) {
        this.pos1 = blockHitResult.method_17777().method_25503();
    }

    public void rightClick(class_3965 blockHitResult) {
        if (this.pos1 != null) {
            this.pos2 = blockHitResult.method_17777().method_25503();
        }
    }

    public void middleClick(class_3965 blockHitResult) {
        if (Axiom.configuration.builderTools.middleClick == BuilderToolMiddleClick.MAGIC_SELECT) {
            class_2338 hit = blockHitResult.method_17777();
            MagicSelectionPreciseTask task = new MagicSelectionPreciseTask(new PositionSet(), (class_1937)class_310.method_1551().field_1687, hit, 0);
            task.fill(Axiom.configuration.builderTools.magicSelectCount);
            if (this.magicSelectRegion == null) {
                this.magicSelectRegion = new ChunkedBooleanRegion(task.positionSet);
            } else {
                this.magicSelectRegion.addAll(task.positionSet);
            }
        } else if (this.pos1 == null) {
            this.pos1 = blockHitResult.method_17777().method_25503();
        } else if (this.pos2 == null) {
            this.pos2 = blockHitResult.method_17777().method_25503();
        } else {
            BuilderTool.extend(blockHitResult.method_17777(), this.pos1, this.pos2);
        }
    }

    @Nullable
    public Restore getSelectionRestore() {
        if (this.pos1 == null && this.pos2 == null && this.magicSelectRegion == null) {
            return null;
        }
        return new Restore(this.pos1 == null ? null : this.pos1.method_10062(), this.pos2 == null ? null : this.pos2.method_10062(), this.magicSelectRegion == null ? null : this.magicSelectRegion.copyPositionSet());
    }

    public void restoreFrom(Restore restore) {
        if (restore == null) {
            return;
        }
        this.pos1 = restore.pos1 == null ? null : restore.pos1.method_25503();
        class_2338.class_2339 class_23392 = this.pos2 = restore.pos2 == null ? null : restore.pos2.method_25503();
        if (this.magicSelectRegion != null) {
            this.magicSelectRegion.close();
            this.magicSelectRegion = null;
        }
        if (restore.set != null) {
            this.magicSelectRegion = new ChunkedBooleanRegion(restore.set);
        }
    }

    public record Restore(class_2338 pos1, class_2338 pos2, PositionSet set) {
    }
}

