/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.block_maps;

import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.tools.Tool;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2482;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import net.minecraft.class_5793;
import net.minecraft.class_5794;

public class HDVoxelMap {
    private static final Map<class_2248, HDVoxelBaseBlocks> VOXEL_BASE_BLOCKS_MAP = new HashMap<class_2248, HDVoxelBaseBlocks>();
    private static final Map<class_2248, HDVoxelBaseBlocks> VOXEL_BASE_BLOCKS_FULL_MAP = new HashMap<class_2248, HDVoxelBaseBlocks>();
    public static int[] validVoxel222;

    private static void process(class_2248 full, class_2248 stair, class_2248 slab) {
        HDVoxelBaseBlocks hdVoxelBaseBlocks = new HDVoxelBaseBlocks(full, stair, slab);
        VOXEL_BASE_BLOCKS_FULL_MAP.put(full, hdVoxelBaseBlocks);
        VOXEL_BASE_BLOCKS_MAP.put(full, hdVoxelBaseBlocks);
        VOXEL_BASE_BLOCKS_MAP.put(stair, hdVoxelBaseBlocks);
        VOXEL_BASE_BLOCKS_MAP.put(slab, hdVoxelBaseBlocks);
    }

    public static HDVoxelBaseBlocks getAssociatedBlocks(class_2248 block) {
        return VOXEL_BASE_BLOCKS_MAP.get(block);
    }

    public static HDVoxelBaseBlocks getAssociatedBlocksForFull(class_2248 block) {
        return VOXEL_BASE_BLOCKS_FULL_MAP.get(block);
    }

    public static void downsizePathTool(ChunkedBlockRegion doubleSizeRegion, ChunkedBlockRegion into) {
        class_2680 slab;
        class_2680 stair;
        class_2680 full;
        PositionSet tempSet = new PositionSet();
        doubleSizeRegion.forEachChunk((cx, cy, cz, blocks) -> {
            class_2680[] minusX = doubleSizeRegion.getChunk(cx - 1, cy, cz);
            class_2680[] plusX = doubleSizeRegion.getChunk(cx + 1, cy, cz);
            class_2680[] minusY = doubleSizeRegion.getChunk(cx, cy - 1, cz);
            class_2680[] plusY = doubleSizeRegion.getChunk(cx, cy + 1, cz);
            class_2680[] minusZ = doubleSizeRegion.getChunk(cx, cy, cz - 1);
            class_2680[] plusZ = doubleSizeRegion.getChunk(cx, cy, cz + 1);
            for (int x = 0; x < 16; x += 2) {
                for (int y = 0; y < 16; y += 2) {
                    for (int z = 0; z < 16; z += 2) {
                        int bits = 0;
                        if (blocks[x + y * 16 + z * 16 * 16] != null) {
                            bits |= 0x80;
                        }
                        if (blocks[x + y * 16 + (z + 1) * 16 * 16] != null) {
                            bits |= 0x40;
                        }
                        if (blocks[x + 1 + y * 16 + z * 16 * 16] != null) {
                            bits |= 0x20;
                        }
                        if (blocks[x + 1 + y * 16 + (z + 1) * 16 * 16] != null) {
                            bits |= 0x10;
                        }
                        if (blocks[x + (y + 1) * 16 + z * 16 * 16] != null) {
                            bits |= 8;
                        }
                        if (blocks[x + (y + 1) * 16 + (z + 1) * 16 * 16] != null) {
                            bits |= 4;
                        }
                        if (blocks[x + 1 + (y + 1) * 16 + z * 16 * 16] != null) {
                            bits |= 2;
                        }
                        if (blocks[x + 1 + (y + 1) * 16 + (z + 1) * 16 * 16] != null) {
                            bits |= 1;
                        }
                        if (bits == 0) continue;
                        int minError = Integer.MAX_VALUE;
                        int closestValid = 255;
                        for (int voxel : validVoxel222) {
                            int different = (bits ^ voxel) & 0xFF;
                            int error2 = Integer.bitCount(different) * 3;
                            if ((different & 0x80) != 0 && (voxel & 0x80) != 0) {
                                error2 += HDVoxelMap.penalizeJagged(x, y, z, blocks, minusX, plusX, minusY, plusY, minusZ, plusZ) * 2;
                            }
                            if ((different & 0x40) != 0 && (voxel & 0x40) != 0) {
                                error2 += HDVoxelMap.penalizeJagged(x, y, z + 1, blocks, minusX, plusX, minusY, plusY, minusZ, plusZ) * 2;
                            }
                            if ((different & 0x20) != 0 && (voxel & 0x20) != 0) {
                                error2 += HDVoxelMap.penalizeJagged(x + 1, y, z, blocks, minusX, plusX, minusY, plusY, minusZ, plusZ) * 2;
                            }
                            if ((different & 0x10) != 0 && (voxel & 0x10) != 0) {
                                error2 += HDVoxelMap.penalizeJagged(x + 1, y, z + 1, blocks, minusX, plusX, minusY, plusY, minusZ, plusZ) * 2;
                            }
                            if ((different & 8) != 0 && (voxel & 8) != 0) {
                                error2 += HDVoxelMap.penalizeJagged(x, y + 1, z, blocks, minusX, plusX, minusY, plusY, minusZ, plusZ) * 2;
                            }
                            if ((different & 4) != 0 && (voxel & 4) != 0) {
                                error2 += HDVoxelMap.penalizeJagged(x, y + 1, z + 1, blocks, minusX, plusX, minusY, plusY, minusZ, plusZ) * 2;
                            }
                            if ((different & 2) != 0 && (voxel & 2) != 0) {
                                error2 += HDVoxelMap.penalizeJagged(x + 1, y + 1, z, blocks, minusX, plusX, minusY, plusY, minusZ, plusZ) * 2;
                            }
                            if ((different & 1) != 0 && (voxel & 1) != 0) {
                                error2 += HDVoxelMap.penalizeJagged(x + 1, y + 1, z + 1, blocks, minusX, plusX, minusY, plusY, minusZ, plusZ) * 2;
                            }
                            error2 *= 16;
                            if ((error2 += 8 - Integer.bitCount(voxel & 0xFF)) >= minError) continue;
                            minError = error2;
                            closestValid = voxel;
                        }
                        if ((closestValid & 0x80) != 0) {
                            tempSet.add(cx * 16 + x, cy * 16 + y, cz * 16 + z);
                        }
                        if ((closestValid & 0x40) != 0) {
                            tempSet.add(cx * 16 + x, cy * 16 + y, cz * 16 + z + 1);
                        }
                        if ((closestValid & 0x20) != 0) {
                            tempSet.add(cx * 16 + x + 1, cy * 16 + y, cz * 16 + z);
                        }
                        if ((closestValid & 0x10) != 0) {
                            tempSet.add(cx * 16 + x + 1, cy * 16 + y, cz * 16 + z + 1);
                        }
                        if ((closestValid & 8) != 0) {
                            tempSet.add(cx * 16 + x, cy * 16 + y + 1, cz * 16 + z);
                        }
                        if ((closestValid & 4) != 0) {
                            tempSet.add(cx * 16 + x, cy * 16 + y + 1, cz * 16 + z + 1);
                        }
                        if ((closestValid & 2) != 0) {
                            tempSet.add(cx * 16 + x + 1, cy * 16 + y + 1, cz * 16 + z);
                        }
                        if ((closestValid & 1) == 0) continue;
                        tempSet.add(cx * 16 + x + 1, cy * 16 + y + 1, cz * 16 + z + 1);
                    }
                }
            }
        });
        PositionSet tempSet2 = new PositionSet();
        tempSet.forEach((x, y, z) -> {
            tempSet2.add(x, y, z);
            if (tempSet.contains(x + 2, y, z)) {
                tempSet2.add(x + 1, y, z);
            }
            if (tempSet.contains(x, y + 2, z)) {
                tempSet2.add(x, y + 1, z);
            }
            if (tempSet.contains(x, y, z + 2)) {
                tempSet2.add(x, y, z + 1);
            }
        });
        class_2680 activeBlock = Tool.getActiveBlock();
        HDVoxelBaseBlocks blocks2 = HDVoxelMap.getAssociatedBlocks(activeBlock.method_26204());
        if (blocks2 == null) {
            full = class_2246.field_10340.method_9564();
            stair = class_2246.field_10440.method_9564();
            slab = class_2246.field_10454.method_9564();
        } else {
            full = blocks2.full().method_9564();
            stair = blocks2.stair().method_9564();
            slab = blocks2.slab().method_9564();
        }
        tempSet2.forEachChunk((cx, cy, cz, chunk) -> {
            for (int x = 0; x < 16; x += 2) {
                for (int y = 0; y < 16; y += 2) {
                    for (int z = 0; z < 16; z += 2) {
                        int bits = 0;
                        if ((chunk[y + z * 16] & 1 << x) != 0) {
                            bits |= 0x80;
                        }
                        if ((chunk[y + (z + 1) * 16] & 1 << x) != 0) {
                            bits |= 0x40;
                        }
                        if ((chunk[y + z * 16] & 1 << x + 1) != 0) {
                            bits |= 0x20;
                        }
                        if ((chunk[y + (z + 1) * 16] & 1 << x + 1) != 0) {
                            bits |= 0x10;
                        }
                        if ((chunk[y + 1 + z * 16] & 1 << x) != 0) {
                            bits |= 8;
                        }
                        if ((chunk[y + 1 + (z + 1) * 16] & 1 << x) != 0) {
                            bits |= 4;
                        }
                        if ((chunk[y + 1 + z * 16] & 1 << x + 1) != 0) {
                            bits |= 2;
                        }
                        if ((chunk[y + 1 + (z + 1) * 16] & 1 << x + 1) != 0) {
                            bits |= 1;
                        }
                        if (bits == 0) continue;
                        class_2680 validBlock = HDVoxelMap.createFromVoxel222(bits, full, stair, slab);
                        into.addBlockWithoutDirty(cx * 8 + x / 2, cy * 8 + y / 2, cz * 8 + z / 2, validBlock);
                    }
                }
            }
        });
    }

    private static int penalizeJagged(int x, int y, int z, class_2680[] blocks, class_2680[] minusX, class_2680[] plusX, class_2680[] minusY, class_2680[] plusY, class_2680[] minusZ, class_2680[] plusZ) {
        boolean minusEmpty;
        boolean plusEmpty;
        int jagged = 0;
        boolean bl = x == 15 ? plusX == null || plusX[0 + y * 16 + z * 16 * 16] == null : (plusEmpty = blocks[x + 1 + y * 16 + z * 16 * 16] == null);
        boolean bl2 = x == 0 ? minusX == null || minusX[15 + y * 16 + z * 16 * 16] == null : (minusEmpty = blocks[x - 1 + y * 16 + z * 16 * 16] == null);
        if (plusEmpty && minusEmpty) {
            ++jagged;
        }
        boolean bl3 = y == 15 ? plusY == null || plusY[x + 0 + z * 16 * 16] == null : (plusEmpty = blocks[x + (y + 1) * 16 + z * 16 * 16] == null);
        boolean bl4 = y == 0 ? minusY == null || minusY[x + 240 + z * 16 * 16] == null : (minusEmpty = blocks[x + (y - 1) * 16 + z * 16 * 16] == null);
        if (plusEmpty && minusEmpty) {
            ++jagged;
        }
        boolean bl5 = z == 15 ? plusZ == null || plusZ[x + y * 16 + 0] == null : (plusEmpty = blocks[x + y * 16 + (z + 1) * 16 * 16] == null);
        boolean bl6 = z == 0 ? minusZ == null || minusZ[x + y * 16 + 3840] == null : (minusEmpty = blocks[x + y * 16 + (z - 1) * 16 * 16] == null);
        if (plusEmpty && minusEmpty) {
            ++jagged;
        }
        return jagged;
    }

    public static int createVoxel222ForStair(class_2680 blockState) {
        int opposite = switch ((class_2778)blockState.method_11654((class_2769)class_2741.field_12503)) {
            default -> throw new IncompatibleClassChangeError();
            case class_2778.field_12710 -> 10;
            case class_2778.field_12708 -> 8;
            case class_2778.field_12709 -> 2;
            case class_2778.field_12712 -> 14;
            case class_2778.field_12713 -> 11;
        };
        int rotate = switch ((class_2350)blockState.method_11654((class_2769)class_2741.field_12481)) {
            case class_2350.field_11043 -> 0;
            case class_2350.field_11035 -> 2;
            case class_2350.field_11039 -> 1;
            case class_2350.field_11034 -> 3;
            default -> throw new IllegalStateException();
        };
        opposite = opposite & 3 | (opposite & 4) << 1 | (opposite & 8) >> 1;
        opposite <<= rotate;
        opposite = (opposite | (opposite & 0xF0) >> 4) & 0xF;
        opposite = opposite & 3 | (opposite & 4) << 1 | (opposite & 8) >> 1;
        int voxel = blockState.method_11654((class_2769)class_2741.field_12518) == class_2760.field_12617 ? 0xF0 | opposite : 0xF | opposite << 4;
        return voxel;
    }

    public static class_2680 createFromVoxel222(int voxel, class_2680 full, class_2680 stair, class_2680 slab) {
        if (voxel == 0) {
            return class_2246.field_10124.method_9564();
        }
        if (voxel == 255) {
            return full;
        }
        if ((voxel & 0xF0) == 240) {
            int upperCount = Integer.bitCount(voxel & 0xF);
            if (upperCount == 0) {
                return (class_2680)slab.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681);
            }
            if (upperCount == 1) {
                stair = (class_2680)stair.method_11657((class_2769)class_2741.field_12518, (Comparable)class_2760.field_12617);
                stair = (class_2680)stair.method_11657((class_2769)class_2741.field_12503, (Comparable)class_2778.field_12708);
                class_2350 stairFacing = (voxel & 1) != 0 ? class_2350.field_11035 : ((voxel & 2) != 0 ? class_2350.field_11034 : ((voxel & 4) != 0 ? class_2350.field_11039 : class_2350.field_11043));
                return (class_2680)stair.method_11657((class_2769)class_2741.field_12481, (Comparable)stairFacing);
            }
            if (upperCount == 2) {
                stair = (class_2680)stair.method_11657((class_2769)class_2741.field_12518, (Comparable)class_2760.field_12617);
                stair = (class_2680)stair.method_11657((class_2769)class_2741.field_12503, (Comparable)class_2778.field_12710);
                class_2350 stairFacing = null;
                if ((voxel & 1) != 0) {
                    if ((voxel & 2) != 0) {
                        stairFacing = class_2350.field_11034;
                    } else if ((voxel & 4) != 0) {
                        stairFacing = class_2350.field_11035;
                    }
                } else if ((voxel & 8) != 0) {
                    if ((voxel & 2) != 0) {
                        stairFacing = class_2350.field_11043;
                    } else if ((voxel & 4) != 0) {
                        stairFacing = class_2350.field_11039;
                    }
                }
                if (stairFacing == null) {
                    return null;
                }
                return (class_2680)stair.method_11657((class_2769)class_2741.field_12481, (Comparable)stairFacing);
            }
            if (upperCount == 3) {
                stair = (class_2680)stair.method_11657((class_2769)class_2741.field_12518, (Comparable)class_2760.field_12617);
                stair = (class_2680)stair.method_11657((class_2769)class_2741.field_12503, (Comparable)class_2778.field_12712);
                class_2350 stairFacing = (voxel & 1) == 0 ? class_2350.field_11043 : ((voxel & 2) == 0 ? class_2350.field_11039 : ((voxel & 4) == 0 ? class_2350.field_11034 : class_2350.field_11035));
                return (class_2680)stair.method_11657((class_2769)class_2741.field_12481, (Comparable)stairFacing);
            }
        } else if ((voxel & 0xF) == 15) {
            int lowerCount = Integer.bitCount(voxel & 0xF0);
            if (lowerCount == 0) {
                return (class_2680)slab.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679);
            }
            if (lowerCount == 1) {
                stair = (class_2680)stair.method_11657((class_2769)class_2741.field_12518, (Comparable)class_2760.field_12619);
                stair = (class_2680)stair.method_11657((class_2769)class_2741.field_12503, (Comparable)class_2778.field_12708);
                class_2350 stairFacing = (voxel & 0x10) != 0 ? class_2350.field_11035 : ((voxel & 0x20) != 0 ? class_2350.field_11034 : ((voxel & 0x40) != 0 ? class_2350.field_11039 : class_2350.field_11043));
                return (class_2680)stair.method_11657((class_2769)class_2741.field_12481, (Comparable)stairFacing);
            }
            if (lowerCount == 2) {
                stair = (class_2680)stair.method_11657((class_2769)class_2741.field_12518, (Comparable)class_2760.field_12619);
                stair = (class_2680)stair.method_11657((class_2769)class_2741.field_12503, (Comparable)class_2778.field_12710);
                class_2350 stairFacing = null;
                if ((voxel & 0x10) != 0) {
                    if ((voxel & 0x20) != 0) {
                        stairFacing = class_2350.field_11034;
                    } else if ((voxel & 0x40) != 0) {
                        stairFacing = class_2350.field_11035;
                    }
                } else if ((voxel & 0x80) != 0) {
                    if ((voxel & 0x20) != 0) {
                        stairFacing = class_2350.field_11043;
                    } else if ((voxel & 0x40) != 0) {
                        stairFacing = class_2350.field_11039;
                    }
                }
                if (stairFacing == null) {
                    return null;
                }
                return (class_2680)stair.method_11657((class_2769)class_2741.field_12481, (Comparable)stairFacing);
            }
            if (lowerCount == 3) {
                stair = (class_2680)stair.method_11657((class_2769)class_2741.field_12518, (Comparable)class_2760.field_12619);
                stair = (class_2680)stair.method_11657((class_2769)class_2741.field_12503, (Comparable)class_2778.field_12712);
                class_2350 stairFacing = (voxel & 0x10) == 0 ? class_2350.field_11043 : ((voxel & 0x20) == 0 ? class_2350.field_11039 : ((voxel & 0x40) == 0 ? class_2350.field_11034 : class_2350.field_11035));
                return (class_2680)stair.method_11657((class_2769)class_2741.field_12481, (Comparable)stairFacing);
            }
        }
        return null;
    }

    static {
        class_5793.method_33467().forEach(blockFamily -> {
            class_2248 base = blockFamily.method_33469();
            class_2248 stairs = blockFamily.method_33470(class_5794.class_5796.field_28540);
            class_2248 slab = blockFamily.method_33470(class_5794.class_5796.field_28539);
            if (stairs != null && slab != null) {
                HDVoxelMap.process(base, stairs, slab);
            }
        });
        validVoxel222 = new int[]{0, 255, 240, 15, 248, 244, 242, 241, 252, 250, 245, 243, 247, 251, 253, 254, 143, 79, 47, 31, 207, 175, 95, 63, 127, 191, 223, 239};
    }

    public record HDVoxelBaseBlocks(class_2248 full, class_2248 stair, class_2248 slab) {
    }
}

